function crit = criterioFS_SVMc_Fscore_PAR(params, X_tr,y_tr,y_sogg_tr,X_val,y_val,y_sogg_val)
% Feature selection criterion function. 
% If only training set is available a 5-fold cross-validation is conducted.
% The criterion can be choosed varying the crit_var variable in the code of this function:
% 
% 
% set: 
% params.crit_var = -1            = average fscore
% params.crit_var = 0             = accuracy
% params.crit_var = 1:maxlabel    = fscore(label)
% 
% crit = criterioFS_SVMc_Fscore_PAR(params, X_tr,y_tr,y_sogg_tr,X_val,y_val,y_sogg_val)
% 
% 
% [Andrea Mannini: a.mannini@sssup.it; Last modified:  2013]


crit_var = params.crit_var;

% crit_var = -1;
switch crit_var
    case -1
        disp('FS criterion: LOSO AVERAGE FSCORE')
    case 0
        disp('FS criterion: LOSO ACCURACY')
    otherwise
        disp(['FS criterion: LOSO SINGLE CLASS FSCORE, selected class = ' num2str(crit_var )])
end

%% parametri svm
sc_low = params.sc_low;
sc_up = params.sc_up;
bestc = params.bestc;
bestg = params.bestg;
Pb = params.Pb ;
kernel = params.kernel;
maxlabelnum = params.maxlabelnum;
termination = params.termination;    

input.scalingtype = 2;

if nargin<4

    %% cross-validazione svm
    nfold = 5;
    input.inst = X_tr;
    input.labels = y_tr;
    input.subj_label = subj_label;
    input.sc_low = sc_low;
    input.sc_up = sc_up;
    input.kernel = kernel;
    input.C = bestc;
    input.gamma = bestg;
    input.Pb = Pb;
    input.termination = termination;
    input.maxlabelnum = maxlabelnum;
    input.nfold = nfold;
    
    output = cross_valid_svm_PAR(input);
    
    CM_aggr = output.CM_aggr;
%     CM = output.CM;
%     Acc_aggr = output.Acc_aggr;
%     Acc = output.Acc;
%     predict = output.predict;
%     model = output.model;
%     prob = output.prob;
%     predict_sorted = output.predict_sorted;
%     prob_sorted = output.prob_sorted;
else

% % %     % normalizz
% % %     M = max(X_tr);  %max e min per ogni feature
% % %     m = min(X_tr);
% % %     
% % %     for f = 1:F
% % %         X_tr_sc(:,f) = ones(length(X_tr(:,f)),1)*sc_low + (X_tr(:,f)-ones(length(X_tr(:,f)),1)*m(f)) .* (sc_up-sc_low)/(M(f)-m(f));
% % %         X_val_sc(:,f) = ones(length(X_val(:,f)),1)*sc_low + (X_val(:,f)-ones(length(X_val(:,f)),1)*m(f)) .* (sc_up-sc_low)/(M(f)-m(f));
% % %     end

    
    
    if nargin == 7
        test = sum(y_sogg_tr == y_sogg_val) == length( y_sogg_tr);
        if ~test
            error('ERROR: LOSO FS applicable only with resusbstitution method')
        end
        subj_label = y_sogg_tr;
%         subjs = unique(subj_label);
        CM_aggr = zeros(maxlabelnum,maxlabelnum);
        
        
        
%         for subj = 1:length(subjs)
%             subj_val = subjs(subj);
%             X_tr2 = X_tr(subj_label~=subj_val,:);
%             y_tr2 = y_tr(subj_label~=subj_val);
%             X_val2 = X_val(subj_label==subj_val,:);
%             y_val2 = y_val(subj_label==subj_val);
%             X_tr_sc = X_tr2;
%             X_val_sc = X_val2;
% 
%             % FARE SCALING SOLO COPIATO QUI
%             me = mean(X_tr2);
%             st = std(X_tr2);
%             F = size(X_tr2,2);
%             for f = 1:F
%                 X_tr_sc(:,f) = (X_tr2(:,f) - me(f)) ./ st(f);
%                 X_val_sc(:,f) = (X_val2(:,f) - me(f)) ./ st(f);
%             end
%             %%%%
%             
%             %% addestramento su TS e validazione su VS
%             model = svmtrain(y_tr2, X_tr_sc, [' -t ' num2str(kernel)  ' -c ' num2str(bestc) ' -g ' num2str(bestg) ' -b ' num2str(Pb) ' -h 0'  ]);
%             [predict, Acc] = svmpredict(y_val2, X_val_sc, model, [' -b ' num2str(Pb)] );
%             %calcolo matrice di confusione
%             CM_aggr_tmp = zeros(maxlabelnum,maxlabelnum);
%             lab1 = unique(y_val2);
%             lab2 = unique(predict);
%             [CM_aggr_tmp(lab1,lab2),ne,lablist] = confmat(y_val2, predict);
%             CM_aggr = CM_aggr + CM_aggr_tmp;
%         end

            input.inst = X_tr;
            input.labels = y_tr;
            input.subj_label = subj_label;
            input.sc_low = sc_low;
            input.sc_up = sc_up;
            input.kernel = kernel;
            input.C = bestc;
            input.gamma = bestg;
            input.Pb = Pb;
            input.termination = termination;
            input.maxlabelnum = maxlabelnum;

            output = l1o_valid_svm4_PAR(input);

            CM_aggr = output.CM_aggr;
%             CM = output.CM;
%             Acc_aggr = output.Acc_aggr;
%             Acc = output.Acc;
%             predict = output.predict;
%             model = output.model;
%             prob = output.prob;
%             predict_sorted = output.predict_sorted;
%             prob_sorted = output.prob_sorted;

        
        
    else
        
        X_tr_sc = X_tr;
        X_val_sc = X_val;

        % FARE SCALING SOLO COPIATO QUI
        me = mean(X_tr);
        st = std(X_tr);
        F = size(X_tr,2);
        for f = 1:F
            X_tr_sc(:,f) = (X_tr(:,f) - me(f)) ./ st(f);
            X_val_sc(:,f) = (X_val(:,f) - me(f)) ./ st(f);
        end
        %%%%
        
        %% addestramento su TS e validazione su VS
        model = svmtrain(y_tr, X_tr_sc, [' -t ' num2str(kernel)  ' -c ' num2str(bestc) ' -g ' num2str(bestg) ' -b ' num2str(Pb) ' -h 0'  ]);
        [predict, Acc] = svmpredict(y_val, X_val_sc, model, [' -b ' num2str(Pb)] );
        %calcolo matrice di confusione
        CM_aggr = zeros(maxlabelnum,maxlabelnum);
        lab1 = unique(y_val);
        lab2 = unique(predict);
        [CM_aggr(lab1,lab2),ne,lablist] = confmat(y_val, predict);
        
    end

end


%% calcola funzione costo
if crit_var > 0 % fscore classe specifica
    try
        [SE,SP,PR,se,sp,pr,tp,fp,tn,fn] = confmat2SeSpPr(CM_aggr,0);
    catch
        disp('Errore matrice confusione degenere')
    end
    for i = 1:size(CM_aggr,2)
        F1_s(i) = 2/ (1/pr(i)+1/se(i));
    end
    crit = 1/ F1_s(crit_var); % restituisco Fscore relativo alla classe indicata
elseif crit_var == -1 %fscore medio
    try
        [SE,SP,PR,se,sp,pr,tp,fp,tn,fn] = confmat2SeSpPr(CM_aggr,0);
    catch
        disp('Errore matrice confusione degenere')
    end
    for i = 1:size(CM_aggr,2)
        F1_s(i) = 2/ (1/pr(i)+1/se(i));
    end
    crit = 1/ mean(F1_s);
else    % accuratezza
    Acc = trace(CM_aggr)/sum(sum(CM_aggr));
    crit = 1/ Acc; %restituisco accuratezza
end

end